#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>
#include <queue>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

const int MAXN = 32768;
const int kN = 20 * 1000;
const int kInf = 2100 * 1000 * 1000;

vector<pii> g[kN];
vector<int> path[kN];
vector<int> f[kN];

void Dijkstra(int n) {
  vector<int> dist(n, kInf);
  dist[0] = 0;
  priority_queue<pii> pq;
  pq.push(pii(0, 0));
  while (!pq.empty()) {
    auto p = pq.top();
    pq.pop();
    if (dist[p.second] != -p.first) {
      continue;
    }
    int u = p.second;
    int d = -p.first;
    for (int i = 0; i < g[u].size(); ++i) {
      int v = g[u][i].first;
      int w = g[u][i].second;
      if (d + w < dist[v]) {
        path[v].clear();
        path[v].push_back(u);
        dist[v] = d + w;
        pq.push(pii(-dist[v], v));
      } else if (d + w == dist[v]) {
        path[v].push_back(u);
      } 
    }
  }
 // cout << dist[n - 1] << endl;
}

vector<int> tin;
vector<int> fup;
vector<char> used;
int timer = 0;

map<pii, int> cnt;
int res = 0;
int finish;
map <pair <int, int>, int> output;
vector <int> answer;

bool DFS(int v, int p) {
  used[v] = true;
  tin[v] = timer++;
  fup[v] = tin[v];
  bool ok = v == finish;
  for (int i = 0; i < f[v].size(); ++i) {
    int to = f[v][i];
    if (!used[to]) {
      bool curr = DFS(to, v);
      if (curr) {
        ok = true;
      }
      fup[v] = min(fup[v], fup[to]);
      if (fup[to] > tin[v] && cnt[pii(v, to)] == 1 && curr) {
        answer.push_back(output[pii(v, to)]);
        //++res;
        //cout << "bridge: " << v + 1 << ' ' << to + 1 << '\n';
      }
    } else if (to != p) {
      fup[v] = min(fup[v], tin[to]);
    }
  }
  return ok;
}

int main() {
  std::ios_base::sync_with_stdio(false);
  int n, m;
  cin >> n >> m;
  finish = n - 1;
  for (int i = 0; i < m; ++i) {
    int u, v, w;
    cin >> u >> v >> w; --u; --v;
    g[u].push_back(pii(v, w));
    output[pii(u, v)] = i + 1;
    output[pii(v, u)] = i + 1;
  }
  Dijkstra(n);
  for (int u = 0; u < n; ++u) {
    for (int i = 0; i < path[u].size(); ++i) {
      f[path[u][i]].push_back(u);
      f[u].push_back(path[u][i]);
   //   cout << path[u][i] << " " << u << endl;
      ++cnt[pii(path[u][i], u)];
      ++cnt[pii(u, path[u][i])];
    }
  }
  tin.resize(n);
  fup.resize(n);
  used.resize(n);
  DFS(0, -1);

  cout << answer.size() << '\n';
  for (int i = 0; i != answer.size(); ++i) {
    cout << answer[i] << ' ';
  }

  return 0;
}
